<?php

class DiskRepository {

	function addNewDisk(DiskConfiguration $conf) {
		$newDisk = new Disk($conf);
		$this->applyChangesToSystem($newDisk);
	}

	function getAllDisks() {
		return $this->runCommandOnSystemToListAllDisks();
	}

	function getAllSharesOnTheSystem() {
		$nfsShares = array();
		$cifsShares = array();
		$afpShares = array();
		foreach($this->getAllDisks() as $disk) {
			$share = new Shares($disk);
			$nfsShares = array_merge($nfsShares, $share->findAllNFSShares());
			$cifsShares = array_merge($nfsShares, $share->findAllCIFSShares());
			$afpShares = array_merge($nfsShares, $share->findAllAFPShares());
		}

		return array_merge($nfsShares, $cifsShares, $afpShares);
	}

	private function applyChangesToSystem($newDisk) {
		// some logic to apply the changes
	}




}

?>
